#!/bin/bash

# Tworzy zrzut bazy danych (uruchamiany z crona)

	DATE=$(date +"%Y%m%d")
	DST="/home/backup/db/"
	PSQL_DB="edokumenty"
	PSQL_OPTIONS="-p 5432"
	LOG_BACKUP="/var/log/backup_edokumenty"
	
	DATESTART=$(date +"%Y-%m-%d %H:%M:%S")
	
	mkdir -p ${LOG_BACKUP}
	
	if [ -d $DST ]
	then
		sleep 1
		else
			mkdir -p $DST
			chown postgres:postgres $DST
			fi

	echo "Start: Backup bazy danych ${PSQL_DB} ${DATESTART}"  >> ${LOG_BACKUP}/backup_db_${PSQL_DB}.log


	su - postgres -c "pg_dump ${PSQL_OPTIONS} -d ${PSQL_DB} | gzip > ${DST}/${PSQL_DB}_${DATE}.sql.gz"

	#Usunięcie starszych niż 5 dni rzutów bazy
	find ${DST} -name "${PSQL_DB}*.sql.gz" -mtime +4 -type f -delete

	DATEEND=$(date +"%Y-%m-%d %H:%M:%S")
		
	echo "Koniec: Backup bazy danych ${PSQL_DB} ${DATEEND}" >> ${LOG_BACKUP}/backup_db_${PSQL_DB}.log
