#!/bin/bash

# Skrypt do konfiguracji UFW (Uncomplicated Firewall) dla eDokumenty
INSTALL_DIR=$(pwd)

apt install -y ufw

sed -i 's/^ENABLED=.*/ENABLED=yes/' /etc/ufw/ufw.conf
echo -e "\033[01;32mWprowadzono zmianę: ENABLED=yes w /etc/ufw/ufw.conf\033[00m"

sudo ufw reset

# Konfiguracja UFW
echo -e "\033[01;34m Konfiguracja UFW\033[00m"
sudo ufw default deny incoming
sudo ufw default allow outgoing
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw allow 22/tcp


echo -ne "\033[01;33mCzy chcesz włączyć UFW teraz? [y/n]: \033[00m"
read ufwinstall
if [[ "$ufwinstall" =~ ^[Yy]$ ]]; then
    sudo ufw enable
    sudo ufw status verbose
else
    echo -e "\033[01;31mUFW nie został włączony. Możesz to zrobić później poleceniem: sudo ufw enable\033[00m"
fi
