#!/bin/bash

INSTALL_DIR="${1:-$(pwd)}"

# Ustawienie wersji aplikacji
source "$(dirname "$0")/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')
POSTGRESQL_VERSION=$(echo "$POSTGRESQL_VERSION" | tr -d '\n' | tr -d '\r')

DATE=$(date +"%Y%m%d_%H_%M")
BACKUP_CONF_DIR="$INSTALL_DIR/backup_conf_$DATE"

echo -e "\033[01;34m Kopia została utworzona w lokalizacji '$BACKUP_CONF_DIR' \033[00m"

mkdir -p "$BACKUP_CONF_DIR"
mkdir -p "$BACKUP_CONF_DIR/apache2"
mkdir -p "$BACKUP_CONF_DIR/apache2/conf-available"
mkdir -p "$BACKUP_CONF_DIR/apache2/mods-available"
mkdir -p "$BACKUP_CONF_DIR/cli"
mkdir -p "$BACKUP_CONF_DIR/fpm"
mkdir -p "$BACKUP_CONF_DIR/fpm/pool.d"
mkdir -p "$BACKUP_CONF_DIR/redis"
mkdir -p "$BACKUP_CONF_DIR/pgbouncer"
mkdir -p "$BACKUP_CONF_DIR/postgresql"


echo -e "\033[01;34m Kopia plików konfiguracyjnych Apache \033[00m"
  
  #Konfiguracja Apache2
  cp -r /etc/apache2/sites-available/ "$BACKUP_CONF_DIR/apache2/sites-available/"
  cp -p /etc/apache2/apache2.conf "$BACKUP_CONF_DIR/apache2/"
  cp -p /etc/apache2/conf-available/security.conf "$BACKUP_CONF_DIR/apache2/conf-available/" 
  cp -p /etc/apache2/mods-available/ssl.conf "$BACKUP_CONF_DIR/apache2/mods-available/" 
	

echo -e "\033[01;34m Kopia plików konfiguracyjnych PHP \033[00m"	


# Konfiguracja PHP/FPM
if [ -f "/etc/php/$PHP_VERSION/cli/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/cli/php.ini" "$BACKUP_CONF_DIR/cli/"
else
  echo "Plik /etc/php/$PHP_VERSION/cli/php.ini nie istnieje!"
fi

if [ -f "/etc/php/$PHP_VERSION/fpm/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/php.ini" "$BACKUP_CONF_DIR/fpm/"
else
  echo "Plik /etc/php/$PHP_VERSION/fpm/php.ini nie istnieje!"
fi

if [ -f "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" "$BACKUP_CONF_DIR/fpm/pool.d/"
else
  echo "Plik /etc/php/$PHP_VERSION/fpm/pool.d/www.conf nie istnieje!"
fi

echo -e "\033[01;34m Kopia plików konfiguracyjnych Redis \033[00m"	
  #Konfiguracja php-redis
if [ -f /etc/redis/redis.conf ]; then
  cp -p /etc/redis/redis.conf "$BACKUP_CONF_DIR/redis/"
else
  echo "Plik /etc/redis/redis.conf nie istnieje!"
fi

echo -e "\033[01;34m Kopia plików konfiguracyjnych pgbouncer \033[00m"
	#Konfiguracja pgbouncer
  cp -p /etc/pgbouncer/pgbouncer.ini "$BACKUP_CONF_DIR/pgbouncer/"
if [ -f /etc/pgbouncer/userlist.txt ]; then
    cp -p /etc/pgbouncer/userlist.txt "$BACKUP_CONF_DIR/pgbouncer/"
else
  echo "Plik /etc/pgbouncer/userlist.txt nie istnieje!"
fi

echo -e "\033[01;34m Kopia plików PostgreSQL $POSTGRESQL_VERSION - pg_hba.conf \033[00m"
PG_HBA_CONF="/etc/postgresql/$POSTGRESQL_VERSION/main/pg_hba.conf"
POSTGRESQL_CONF="/etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf"

if [ -f "$PG_HBA_CONF" ]; then
  cp -p "$PG_HBA_CONF" "$BACKUP_CONF_DIR/postgresql/"
else
  echo "Plik $PG_HBA_CONF nie istnieje!"
fi

if [ -f "$POSTGRESQL_CONF" ]; then
  cp -p "$POSTGRESQL_CONF" "$BACKUP_CONF_DIR/postgresql/"
else
  echo "Plik $POSTGRESQL_CONF nie istnieje!"
fi
