#!/bin/bash
# Server installation script for 
# Symfonia eDokumenty on Debian 13
#
# @version 13.1.9 (20260209) for Debian 13 Version PHP 8.2, PostgreSQL 17
# @author: eDokumenty sp z o.o.
# @modified: Symfonia sp z o.o.
# @modified Jarosław Połczyński, jaroslaw.polczynski@symfonia.pl
#
# Instrukacja instalcji znajduje w pliku README.md

INSTALL_DIR=$(pwd)
source "$(dirname "$0")/bin/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')
POSTGRESQL_VERSION=$(echo "$POSTGRESQL_VERSION" | tr -d '\n' | tr -d '\r')


# Prezentacja wersji
echo -e "\033[01;32m Instalator Symfonia eDokumenty dla Debian $DEBIAN_VERSION \033[00m"
echo -e "\033[01;34m Postgresql $POSTGRESQL_VERSION \033[00m"
echo -e "\033[01;34m PHP $PHP_VERSION \033[00m"

# Uprawnienie skryptów z katalogu bin
echo
chown -R root:root $INSTALL_DIR/bin/*.sh
chmod u+x -R $INSTALL_DIR/bin/*.sh
chmod u+x $INSTALL_DIR/install.sh

# Sprawdzenie czy skrypt jest uruchomiony jako root
if [ "$(id -u)" != "0" ]; then
   echo -e "\033[01;31m Ten skrypt musi być uruchomiony jako root \033[00m" 1>&2
   exit 1
fi

echo -ne "\033[01;32m Czy chcesz instalowac pakiety managerem apt? Zalecane y (y/n) \033[00m \n"
read APTYESNO
if [[ "$APTYESNO" =~ ^[yY]$ ]]; then

#gnupg, wget, sudo
apt -y install gnupg
apt -y install wget
apt -y install sudo
apt -y install lsb-release
apt -y install curl ca-certificates
apt -y install apt-transport-https

#Dodane na potrzeby wersji PostgreSQL 17 - nie ma w dystrybucji
echo -e "\033[01;34m Dodanie repozytorium dla PostgreSQL $POSTGRESQL_VERSION \033[00m"
sudo mkdir -p /usr/share/postgresql-common/pgdg/
sudo curl -o /usr/share/postgresql-common/pgdg/apt.postgresql.org.asc --fail https://www.postgresql.org/media/keys/ACCC4CF8.asc
sudo sh -c "echo 'deb [signed-by=/usr/share/postgresql-common/pgdg/apt.postgresql.org.asc] https://apt.postgresql.org/pub/repos/apt $(lsb_release -sc)-pgdg main' > /etc/apt/sources.list.d/pgdg.list"
sleep 2

#Dodane na potrzeby wersji php8.2 - nie ma w dystrybucji
echo -e "\033[01;34m Dodanie repozytorium dla PHP $PHP_VERSION \033[00m"
sudo wget -O /etc/apt/trusted.gpg.d/php.gpg https://packages.sury.org/php/apt.gpg 
sudo sh -c 'echo "deb https://packages.sury.org/php/ $(lsb_release -sc) main" > /etc/apt/sources.list.d/php.list'
sleep 1

echo -e "\033[01;34m Odświeżenie repozytoriów \033[00m"
apt update

echo -e "\033[01;34m Instalowanie pakietów podstawowych \033[00m"
# Base tools
apt -y install ssh
apt -y install mc
apt -y install nmap
apt -y install ngrep
apt -y install sed
apt -y install gzip
apt -y install adduser
apt -y install bzip2
apt -y install unzip
apt -y install rsync
apt -y install less
apt -y install rdate
apt -y install vim
apt -y install zip

echo -e "\033[01;34m Instalowanie pakietów systemowych \033[00m"
# System tools
apt -y install cron
apt -y install iproute2
apt -y install tcpdump
apt -y install ntpsec 
apt -y install htop
apt -y install iotop
apt -y install sysstat

echo -e "\033[01;34m Instalowanie dodatkowych pakietów programistycznych i narzędzi \033[00m"
# Additional tools
apt -y install apt-show-versions
apt -y install gcc
apt -y install g++
apt -y install cpp
apt -y install make
apt -y install curl
apt -y install unattended-upgrades

# Processing tools
apt -y install imagemagick
apt -y install html2ps
apt -y install latex2rtf
apt -y install antiword
apt -y install gnuhtml2latex

#Tesseract kompilujemy ze źródeł. Skrypt /bin/ocr_packet.sh
#apt -y install tesseract-ocr
#apt -y install tesseract-ocr-pol

echo -e "\033[01;34m Instalowanie pakietów Apache2, PostgreSQL $POSTGRESQL_VERSION \033[00m"
# Services Apache, PostgreSQL17
apt -y install postgresql-$POSTGRESQL_VERSION
apt -y install apache2
apt -y install libapache2-mod-security2

echo -e "\033[01;34m Instalowanie pakietów PHP $PHP_VERSION \033[00m"
# Services PHP 
apt -y install php$PHP_VERSION-fpm 
apt -y install php$PHP_VERSION-cli 
apt -y install php$PHP_VERSION-common 
apt -y install php$PHP_VERSION-curl 
apt -y install php$PHP_VERSION-mbstring 
apt -y install php$PHP_VERSION-mysql 
apt -y install php$PHP_VERSION-xml 
apt -y install php$PHP_VERSION-gd 
apt -y install php$PHP_VERSION-pgsql 
apt -y install php$PHP_VERSION-bcmath 
apt -y install php$PHP_VERSION-sqlite3 
apt -y install php$PHP_VERSION-imap
apt -y install php$PHP_VERSION-intl 
apt -y install php$PHP_VERSION-xsl 
apt -y install php$PHP_VERSION-ldap 
apt -y install php$PHP_VERSION-odbc 
apt -y install php$PHP_VERSION-sybase 
apt -y install php$PHP_VERSION-readline 
apt -y install php$PHP_VERSION-soap
apt -y install php$PHP_VERSION-zip
apt -y install php$PHP_VERSION-redis
apt -y install php$PHP_VERSION-zmq

echo -e "\033[01;34m Instalowanie pakietów Redis-Server \033[00m"
apt -y install redis-server

apt -y install subversion
apt -y install openssl
apt -y install ssl-cert
apt -y install abiword
apt -y install hdparm

fi


# Instalacja pgbouncer + config
echo -ne "\033[01;32m Czy zainstalowac Pgbouncer? (y/n) \033[00m \n"
read PGBOUNCER
if [[ "$PGBOUNCER" =~ ^[yY]$ ]]; then
    apt -y install pgbouncer
fi

# Instalacja polityka haseł dla usera systemu linux
echo -e "\033[01;34m PAM - polityka haseł systemu Linux - wymagająca co najmniej 16 znaków, różnorodnych typów znaków, ograniczającą powtarzanie znaków i wymuszającą różnice względem poprzedniego hasła, także dla konta root, odrzucenie hasła zawierające nazwę użytkownika -  \033[00m"
echo -ne "\033[01;32m Czy wprowadzić powyższą politykę haseł dla użytkowników system Linux? (y/n) \033[00m \n"
read POLICYUSER
if [[ "$POLICYUSER" =~ ^[yY]$ ]]; then
    apt -y install libpam-pwquality
    sed -i -E '/pam_pwquality\.so/ s/(pam_pwquality\.so.*)/\1 minlen=16 maxrepeat=3 ucredit=-1 lcredit=-1 dcredit=-1 ocredit=-1 difok=3 reject_username enforce_for_root/' /etc/pam.d/common-password
fi

echo -e "\033[01;34m Zakladanie kont i konfiguracja grup dla użytkownika edokumenty \033[00m"
# konta i grupy systemowe dla usera edokumenty
/usr/sbin/adduser --gecos  "" --ingroup users edokumenty
/usr/sbin/groupadd edokumenty
/usr/sbin/adduser edokumenty edokumenty
/usr/sbin/adduser www-data edokumenty

chmod g+rx,o+rx /home/edokumenty


echo -e "\033[01;34m Zakladanie kont i konfiguracja grup dla użytkownika test \033[00m"
# konta i grupy systemowe dla usera test
/usr/sbin/adduser --gecos  "" --ingroup users test
/usr/sbin/groupadd test

chmod g+rx,o+rx /home/test

echo -e "\033[01;34m Aktywacja modulow Apache2 \033[00m"
for module in ssl rewrite userdir vhost_alias actions alias proxy_fcgi headers security2
do 
   /usr/sbin/a2enmod $module;
done

#enable ssl
/usr/sbin/a2ensite default-ssl


# Kopia plikow konfiguracyjnych
echo -ne "\033[01;32m Czy wykonać kopię plików konfiguracyjnych (y/n) \033[00m \n"
read BACKUPCONF
if [[ "$BACKUPCONF" =~ ^[yY]$ ]]; then
    ./bin/backup_conf_client.sh
fi

# Modyfikacje plików konfiguracyjnych
echo -ne "\033[01;32m Czy modyfikowac pliki konfiguracyjne (zalecane y)? (y/n) \033[00m \n"
read CONFYESNO
if [[ "$CONFYESNO" =~ ^[yY]$ ]]; then
echo -e "\033[01;34m Modyfikacja plików konfiguracyjnych Apache2 \033[00m"
	# Zmiana konfiguracji hostow Apache
 
    rm -f /etc/apache2/sites-available/*
    cp -p $INSTALL_DIR'/conf/etc/apache2/sites-available/000-default.conf' /etc/apache2/sites-available/
    cp -p $INSTALL_DIR'/conf/etc/apache2/sites-available/default-ssl.conf' /etc/apache2/sites-available/
    cp -p $INSTALL_DIR'/conf/etc/apache2/apache2.conf' /etc/apache2/

#Dodanie vhost test
echo -e "\033[01;34m Dodanie vhost test \033[00m"
    ./bin/apache2_site.sh

	cp -p $INSTALL_DIR'/conf/etc/apache2/conf-available/security.conf' /etc/apache2/conf-available/
	cp -p $INSTALL_DIR'/conf/etc/apache2/mods-available/ssl.conf' /etc/apache2/mods-available/


echo -e "\033[01;34m Dostarczenie certyfiaktu dla localhost \033[00m"
   # Kopiowanie testowego certyfiaktu dla SSL
    cp -p $INSTALL_DIR'/conf/etc/ssl/edokumenty.pem' /etc/ssl/private/
    cp -p $INSTALL_DIR'/conf/etc/ssl/edokumenty.key' /etc/ssl/private/

echo -e "\033[01;34m Modyfikacja plików konfiguracyjnych PHP-FPM \033[00m"
./bin/php.sh

echo -e "\033[01;34m Modyfikacja plików konfiguracyjnych pgBouncer \033[00m"
./bin/pgbouncer.sh

echo -e "\033[01;34m Modyfikacja plików konfiguracyjnych Redis \033[00m"
./bin/redis.sh

echo -e "\033[01;34m Zmiana konfiguracji dla PostgreSQL 17 \033[00m"
./bin/postgresql.sh

echo -e "\033[01;34m Dodanie parametrów sysctl do modyfikacji ustawień jądra systemu Linux \033[00m"
./bin/sysctl_conf.sh

fi

echo -e "\033[01;34m Utworzenie public_html i pozostałych podkatalogów dla edokumenty. Nadanie uprawenień do odczytu i zapisu \033[00m"
./bin/create_edok_dirs.sh

echo -e "\033[01;34m Utworzenie public_html i pozostałych podkatalogów dla test. Nadanie uprawenień do odczytu i zapisu \033[00m"
./bin/create_test_dirs.sh

echo -e "\033[01;34m Dodanie ramdisk w fstab dla usługi backproc \033[00m"
./bin/fstab.sh

echo -e "\033[01;34m Poprawa uprawnień do plików konfiguracyjnych \033[00m"
./bin/sys_perms.sh

echo -e "\033[01;34m Dodawanie uprawnień do pliku sudoers dla rpm.sh \033[00m"
./bin/sudoers.sh

# Tworzenie użytkowników bazy danych (wszyscy z opcjami N)
echo -e "\033[01;34m Tworzenie ról bazy danych - http (wszystkie opcje N) \033[00m"
if sudo -u postgres psql -tAc "SELECT 1 FROM pg_roles WHERE rolname='http'" | grep -q 1; then
    echo -e "\033[01;33m Rola 'http' już istnieje, pomijam tworzenie. \033[00m"
else
    sudo -u postgres createuser --no-superuser --no-createdb --no-createrole http
    echo -e "\033[01;32m Rola 'http' została utworzona. \033[00m"
fi
echo -e "\033[01;34m Tworzenie ról bazy danych - edokumenty (wszystkie opcje N) \033[00m"
if sudo -u postgres psql -tAc "SELECT 1 FROM pg_roles WHERE rolname='edokumenty'" | grep -q 1; then
    echo -e "\033[01;33m Rola 'edokumenty' już istnieje, pomijam tworzenie. \033[00m"
else
    sudo -u postgres createuser --no-superuser --no-createdb --no-createrole edokumenty
    echo -e "\033[01;32m Rola 'edokumenty' została utworzona. \033[00m"
fi

#Przeniesiono do pliku edok_install.sh
# Tworzenie baz danych
#echo -e "\033[01;34m Tworzenie pustej bazy edokumenty \033[00m"
#sudo -u postgres createdb -E UTF8 edokumenty -O edokumenty

echo -e "\033[01;34m Konfiguracja domyslnego backupu - domyslne skrypty, ustawienia backapu i skrypty crona \033[00m"
./bin/backup_dirs.sh

cd $INSTALL_DIR
  cp -p $INSTALL_DIR'/lib/backup/backup_db.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_repos.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_files.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_publichtml.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_repository.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/clear_edok_var.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/maildrop_clear.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/update_test.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/clean_logs_backproc.sh' /etc/backup/

  chmod 755 /etc/backup/*

  cp -p $INSTALL_DIR'/lib/backup/exclude_test.conf' /etc/backup

  cp -p $INSTALL_DIR'/lib/backup/edokumenty' /etc/cron.d/

# Restart Apache / Postgres / pgbouncer
echo -e "\033[01;34m Restart Apache \033[00m"
sleep 2
systemctl restart apache2

echo -e "\033[01;34m Restart PHP $PHP_VERSION FPM \033[00m"
sleep 2
systemctl restart php$PHP_VERSION-fpm

echo -e "\033[01;34m Restart PostgreSQL $POSTGRESQL_VERSION \033[00m"
sleep 2
systemctl restart postgresql

echo -e "\033[01;34m Restart pgbouncer \033[00m"
sleep 2
systemctl restart pgbouncer

# Kopia plikow konfiguracyjnych
echo -ne "\033[01;32m Czy zainstalować ClamAV (y/n) \033[00m \n"
read CLAMAV
if [[ "$CLAMAV" =~ ^[yY]$ ]]; then
    ./bin/clamav.sh
fi

echo -e "\033[01;34m FileIndexingTool - tworzenie katalogow oraz przenoszenie skryptow \033[00m"

  cp $INSTALL_DIR'/lib/FileIndexingTool/Run.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndex.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndexLog.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndexStatus.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/conf/config.json'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/conf/

echo -e "\033[01;34m Dodanie wpisow do systemowego crona \033[00m"
./bin/cron.sh

echo -ne "\033[01;32m Instalacja pakietów dodatkowych OCR? (y/n) \033[00m \n"
read OCRINSTALL
if [[ "$OCRINSTALL" =~ ^[yY]$ ]]; then
    echo -e "\033[01;34m Instalacja pakietów Tesseract \033[00m"
    ./bin/ocr_packet.sh
fi

echo -ne "\033[01;32m Instalacja dla Generowanie podglądu plików do PDF? (y/n) \033[00m \n"
read PDFINSTALL
if [[ "$PDFINSTALL" =~ ^[yY]$ ]]; then
    echo -e "\033[01;34m Instalacja dla Generowanie podglądu plików do PDF \033[00m"
    ./bin/libreoffice.sh
fi

echo -ne "\033[01;32m Czy chcesz skonfigurować UFW (Uncomplicated Firewall) dla eDokumenty? (y/n) \033[00m \n"
read UFWINSTALL
if [[ "$UFWINSTALL" =~ ^[yY]$ ]]; then
    echo -e "\033[01;34m Konfiguracja UFW dla eDokumenty \033[00m"
    ./bin/ufw.sh
fi

echo -ne "\033[01;32m Czy chcesz pobrać paczkę instalacyjną Symfonia eDokumenty oraz utworzyć pustą bazę danych edokumenty? (y/n) \033[00m \n"
read EDOKINSTALL
if [[ "$EDOKINSTALL" =~ ^[yY]$ ]]; then
    echo -e "\033[01;34m Utworzenie pustej bazy danych edokumenty oraz pobranie paczki instalacyjnej Symfonia eDokumenty wraz z workerami \033[00m"
    ./bin/edok_install.sh
fi

echo -e "\033[01;32m Zakończenie pracy instalatora Symfonia eDokumenty dla Debian $DEBIAN_VERSION \033[00m"