#!/bin/bash

INSTALL_DIR=$(pwd)
# Ustawienie wersji aplikacji
source "$(dirname "$0")/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')
POSTGRESQL_VERSION=$(echo "$POSTGRESQL_VERSION" | tr -d '\n' | tr -d '\r')
TSEARCH_SRC="$INSTALL_DIR/../conf/usr/lib/psql_tearchdata"
TSEARCH_DST="/usr/share/postgresql/$POSTGRESQL_VERSION/tsearch_data"

# Zmiana konfiguracji dla PostgreSQL
sed -i -e "s/#listen_addresses = 'localhost'/listen_addresses = '*'/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/shared_buffers = 128MB/shared_buffers = 2GB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#effective_cache_size = 4GB/effective_cache_size = 6GB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#maintenance_work_mem = 64MB/maintenance_work_mem = 512MB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#checkpoint_completion_target = 0.9/checkpoint_completion_target = 0.9/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#wal_buffers = -1/wal_buffers = 16MB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#default_statistics_target = 100/default_statistics_target = 100/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#random_page_cost = 4.0/random_page_cost = 4.0/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#effective_io_concurrency = 1/effective_io_concurrency = 2/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#work_mem = 4MB/work_mem = 64MB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#huge_pages = try/huge_pages = off/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/min_wal_size = 80MB/min_wal_size = 1GB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/max_wal_size = 1GB/max_wal_size = 4GB/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#max_worker_processes = 8/max_worker_processes = 4/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#max_parallel_workers_per_gather = 2/max_parallel_workers_per_gather = 2/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#max_parallel_maintenance_workers = 2/max_parallel_maintenance_workers = 2/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#max_parallel_workers = 8/max_parallel_workers = 4/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#jit = on/jit = off/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/#password_encryption = scram-sha-256/password_encryption = scram-sha-256/g" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf

# Ustawienia autovacuum i log_line_prefix w postgresql.conf
sed -i -e 's/^#\?log_autovacuum_min_duration.*/log_autovacuum_min_duration = 10min/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum =.*/autovacuum = on/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum_naptime.*/autovacuum_naptime = 1min/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum_vacuum_threshold.*/autovacuum_vacuum_threshold = 20/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum_analyze_threshold.*/autovacuum_analyze_threshold = 10/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum_vacuum_scale_factor.*/autovacuum_vacuum_scale_factor = 0.2/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e 's/^#\?autovacuum_analyze_scale_factor.*/autovacuum_analyze_scale_factor = 0.1/' /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf
sed -i -e "s/^#\?log_line_prefix.*/log_line_prefix = '%m [%p]:[%l] %q%u@%d'/" /etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf


# Zmiana konfiguracji pg_hba.conf
sed -i '/^# "local" is for Unix domain socket connections only$/a\
local   edokumenty      edokumenty                              trust\nlocal   edokumenty      http                                    trust\nlocal   test            edokumenty                              trust\nlocal   test            http                                      trust' /etc/postgresql/$POSTGRESQL_VERSION/main/pg_hba.conf
sed -i '/^local   all             all                                     peer$/d' /etc/postgresql/$POSTGRESQL_VERSION/main/pg_hba.conf



# Kopiowanie plików tsearch_data do katalogu PostgreSQL
if [ -d "$TSEARCH_SRC" ]; then
	echo -e "\033[01;34mKopiowanie plików tsearch_data z $TSEARCH_SRC do $TSEARCH_DST\033[00m"
	mkdir -p "$TSEARCH_DST"
	cp -v "$TSEARCH_SRC"/* "$TSEARCH_DST/"
	echo -e "\033[01;34mNadawanie uprawnień 644 dla plików w $TSEARCH_DST\033[00m"
	chmod 644 "$TSEARCH_DST"/*
	echo -e "\033[01;34mNadawanie właściciela root:root dla plików w $TSEARCH_DST\033[00m"
	chown root:root "$TSEARCH_DST"/*
else
	echo -e "\033[01;33mBrak katalogu $TSEARCH_SRC - pomijam kopiowanie tsearch_data.\033[00m"
fi
