#!/bin/bash

# Pobierz adres IP (pierwszy z listy)
ip_address=$(hostname -I | awk '{print $1}')
source "$(dirname "$0")/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')

# Tworzenie baz danych
if sudo -u postgres psql -lqt | cut -d \| -f 1 | grep -qw edokumenty; then
	echo -e "\033[01;31m Baza danych 'edokumenty' już istnieje! \033[00m"
else
	echo -e "\033[01;34m Tworzenie pustej bazy edokumenty \033[00m"
	sudo -u postgres createdb -E UTF8 edokumenty -O edokumenty
fi


# Pobranie najnowszej wersji Symfonia eDokumenty
echo -e "\033[01;92m Pobranie najnowszej wersji Symfonia eDokumenty - podaj login oraz hasło \033[00m"
read -p "Wprowadź login do support.edokumenty.eu: " user
read -s -p "Wprowadź hasło do support.edokumenty.eu: " pass
echo


if ! wget -qO- --http-user="$user" --http-password="$pass" http://support.edokumenty.eu/download/application/ready/stable/ | sed -e 's/<[^>]*>//g' > downloaded_file.txt; then
	echo -e "\033[01;31m Błąd pobierania listy paczek. Sprawdź login i hasło. \033[00m"
	exit 1
fi
if ! grep -q "Ready_v" downloaded_file.txt; then
	echo -e "\033[01;31m Brak dostępnych paczek lub nieprawidłowe dane logowania. \033[00m"
	exit 1
fi
echo -e "\033[01;34m Lista dostępnych paczek:\033[00m"

# Filtrowanie paczek tylko dla zadeklarowanej wersji PHP
php_pattern="php${PHP_VERSION//./}" # np. php82
# Sortowanie malejąco (od najnowszej wersji)
package_list=$(grep "Ready_v" downloaded_file.txt | grep "$php_pattern" | sort -r)
echo "$package_list" | awk '{print NR ". " $1}'
read -p "Podaj numer pliku do pobrania: " file_num
selected_file=$(echo "$package_list" | awk "NR==$file_num {print \$1}")

while [ -z "$selected_file" ]; do
	echo -e "\033[01;31m Nieprawidłowy wybór. Spróbuj ponownie. \033[00m"
	read -p "Podaj numer pliku do pobrania: " file_num
	selected_file=$(echo "$package_list" | awk "NR==$file_num {print \$1}")
done

wget --http-user="$user" --http-password="$pass" -P /home/edokumenty https://support.edokumenty.eu/download/application/ready/stable/$selected_file
chown -R edokumenty:edokumenty /home/edokumenty/$selected_file
chmod 775 /home/edokumenty/$selected_file
su -c "unzip /home/edokumenty/$selected_file" - edokumenty


# Zmiana rozszerzeń plików *_default na .toml
echo -e "\033[01;34m Zmiana rozszerzeń plików *_default na .toml \033[00m"
./bin/rename_selected_toml.sh


# ready-cli config:compile - kompilacja konfiguracji
echo -e "\033[01;90m ready-cli config:compile - kompilacja konfiguracji \033[00m"
su -c "cd /home/edokumenty && /home/edokumenty/ready-cli config:compile"


# fixperms - weryfikacja uprawnień
echo -e "\033[01;90m fixperms - weryfikacja uprawnień \033[00m"
su -c "cd /home/edokumenty && /home/edokumenty/bin/fixperms.sh"


if command -v supervisorctl >/dev/null 2>&1; then
	su -c "cd /home/edokumenty && ./ready-cli supervisor:config:create"
else
	echo -e "\033[01;33m Supervisor nie jest zainstalowany. Pomijam tworzenie workerów. Zainstaluje supervisor i ponów ręcznie komendę ./ready-cli supervisor:config:create \033[00m"
fi


echo -e "\033[01;92m Pobieranie paczki zakończone. Dalsze kroki wykonaj przez przeglądarkę wpisując adres serwera http://$ip_address, na którym zainstalowano Symfonia eDokumenty \033[00m"
echo -e " "