#!/bin/bash
LOGFILE="/var/log/clamav/clamav-scan.log";
EMAIL_MSG="Please see the log file attached.";
EMAIL_FROM="clamav-daily@example.com";
EMAIL_TO="your_email@example.com";
DIRTOSCAN="/home/edokumenty /home/backup";


for S in ${DIRTOSCAN}; do
 DIRSIZE=$(du -sh "$S" 2>/dev/null | cut -f1);

    echo "Rozpoczęcie codziennego skanowania folderu: "$S".
     Ilość danych do zeskanowania wynosi: "$DIRSIZE".";

    # Dodaj datę i godzinę przed skanowaniem
    echo " " >> "$LOGFILE"
    echo " " >> "$LOGFILE"
    echo "--- Rozpoczęcie skanowania: $(date '+%Y-%m-%d %H:%M:%S') ---" >> "$LOGFILE"

    clamscan -ri "$S" >> "$LOGFILE";

    # Dodaj datę i godzinę po skanowaniu
    echo " " >> "$LOGFILE"
    echo "--- Zakończenie skanowania: $(date '+%Y-%m-%d %H:%M:%S') ---" >> "$LOGFILE"

    # get the value of "Infected lines"
    MALWARE=$(tail "$LOGFILE"|grep Infected|cut -d" " -f3);

    # if the value is not equal to zero, send an email with the log file attached
    if [ "$MALWARE" -ne "0" ];then
        # using heirloom-mailx below
        echo "$EMAIL_MSG"|mail -a "$LOGFILE" -s "Malware Found" -r "$EMAIL_FROM" "$EMAIL_TO";
    fi 
done

           exit 0