#!/bin/bash

# Skrypt tworzy wersję test
   
      DATE=$(date +"%Y%m%d")
	  DST="/home/backup/db"
	  ENV_PROD="edokumenty"
	  ENV_TEST="test"
	  EXT_URL="localhost"
	  PSQL_OPTIONS="-p 5432"
	  LOG_BACKUP="/var/log/backup_edokumenty"
	  OPTIONS="--force --ignore-errors --delete --delete-excluded \
				   --exclude-from=/etc/backup/exclude_test.conf -a"
    
	  DATESTART=$(date +"%Y-%m-%d %H:%M:%S")

	  mkdir -p ${LOG_BACKUP}

	echo "Start: Odtworzenie wersji ${ENV_TEST} - ${DATESTART}"  >> ${LOG_BACKUP}/restore_${ENV_TEST}_version.log  


		su - postgres -c "psql ${PSQL_OPTIONS} -c \"SELECT pg_terminate_backend(pg_stat_activity.pid) FROM pg_stat_activity WHERE pg_stat_activity.datname = '${ENV_TEST}' AND pid <> pg_backend_pid();\""
		su - postgres -c "dropdb ${PSQL_OPTIONS} ${ENV_TEST}"
		su - postgres -c "createdb ${PSQL_OPTIONS} -O edokumenty ${ENV_TEST}"
		su - postgres -c "gunzip -c $DST/${ENV_PROD}_${DATE}.sql.gz | psql ${PSQL_OPTIONS} ${ENV_TEST}"

		#Usunięcie konta ePUAP
		sudo -u postgres -H -- psql ${PSQL_OPTIONS} -d ${ENV_TEST} -c "UPDATE epuap.entities SET is_del = true;"

		#Usunięcie konfiguracji
		sudo -u postgres -H -- psql ${PSQL_OPTIONS} -d ${ENV_TEST} -c "delete from user_sys_conf where objnam ~* 'simpletable2/MOD_STATUS_LIST';"

		#Usunięcie email z testowego środowiska
		sudo -u postgres -H -- psql ${PSQL_OPTIONS} -d ${ENV_TEST} -c "UPDATE users SET e_mail = NULL;"

		rsync $OPTIONS /home/${ENV_PROD}/public_html/ /home/${ENV_TEST}/public_html/
		rsync $OPTIONS /home/${ENV_PROD}/etc/ /home/${ENV_TEST}/etc/
		rsync $OPTIONS /home/${ENV_PROD}/bin/ /home/${ENV_TEST}/bin/
		rsync $OPTIONS /home/${ENV_PROD}/lib/ /home/${ENV_TEST}/lib/
		rsync $OPTIONS /home/${ENV_PROD}/src/ /home/${ENV_TEST}/src/
		rsync $OPTIONS /home/${ENV_PROD}/vendor/ /home/${ENV_TEST}/vendor/
																		       
		#Zmiana konfiguracji środowiska
		sed -i -e "s/dbname=${ENV_PROD}/dbname=${ENV_TEST}/g" /home/${ENV_TEST}/public_html/apps/edokumenty/config.inc
		sed -i -e "s/define('ROBO_VERSION', FALSE);/define('ROBO_VERSION', 'WERSJA ${ENV_TEST} AUTO');/g" /home/${ENV_TEST}/public_html/apps/edokumenty/config.inc
		sed -i -e "s/define('APPLICATION_NAME', 'Symfonia eDokumenty')/define('APPLICATION_NAME', 'WERSJA ${ENV_TEST} Symfonia eDokumenty')/g" /home/${ENV_TEST}/public_html/apps/edokumenty/config.inc
		sed -i -e "s/define('EXT_ACTIONS_ENGINE_URL', 'http:\/\/${EXT_URL}')/define('EXT_ACTIONS_ENGINE_URL', 'http:\/\/${EXT_URL}\/${ENV_TEST}')/g" /home/${ENV_TEST}/public_html/apps/edokumenty/config.inc
		sed -i -e "s/owner = \"${ENV_PROD}\"/owner = \"${ENV_TEST}\"/g" /home/${ENV_TEST}/etc/env.toml
		sed -i -e "s/data_group = \"${ENV_PROD}\"/data_group = \"${ENV_TEST}\"/g" /home/${ENV_TEST}/etc/env.toml
		
		#Aktualizacja uprawnień dla środowiska 
		cd /home/${ENV_TEST}
		./bin/fixperms.sh
	
	
	
	  DATEEND=$(date +"%Y-%m-%d %H:%M:%S")
	
	echo "Koniec: Odtworzenia wersji ${ENV_TEST} - ${DATEEND}" >> ${LOG_BACKUP}/restore_${ENV_TEST}_version.log
