#!/bin/bash

# Ustawienie wersji aplikacji
INSTALL_DIR=$(pwd)
source "$(dirname "$0")/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')
POSTGRESQL_VERSION=$(echo "$POSTGRESQL_VERSION" | tr -d '\n' | tr -d '\r')

# Ustawienie parametrów dla PHP
IONCUBE_PATH="/usr/lib/php/ioncube_loader_lin_$PHP_VERSION.so"
MEMORY_LIMIT="512M"
UPLOAD_MAX_FILESIZE="32M"
POST_MAX_SIZE="64M"
EXPOSE_PHP="Off"
DATE_TIMEZONE="Europe/Warsaw"
SESSION_NAME="EDOKUMENTYSESSID"
MAX_INPUT_VARS="2500"
ERROR_LOG="/var/log/php_error.log"
SESSION_SAVE_HANDLER="redis"
SESSION_SAVE_PATH="tcp://127.0.0.1:6379"

# Modyfikacja pliku konfiguracyjnego PHP-CLI
echo -e "\033[01;34m Modyfikacja pliku konfiguracyjnego PHP-CLI / PHP-FPM \033[00m"

for INI in /etc/php/$PHP_VERSION/cli/php.ini /etc/php/$PHP_VERSION/fpm/php.ini; do
    if ! grep -q "^zend_extension=$IONCUBE_PATH" "$INI"; then
      sed -i "1izend_extension=$IONCUBE_PATH" "$INI"
    else
      echo -e "\033[01;33mWpis 'zend_extension=$IONCUBE_PATH' już istnieje w $INI\033[00m"
    fi

    if [[ "$INI" == "/etc/php/$PHP_VERSION/fpm/php.ini" ]]; then
        sed -i "s/^memory_limit.*/memory_limit = $MEMORY_LIMIT/" "$INI"
    fi
    
    sed -i "s/^upload_max_filesize.*/upload_max_filesize = $UPLOAD_MAX_FILESIZE/" "$INI"
    sed -i "s/^post_max_size.*/post_max_size = $POST_MAX_SIZE/" "$INI"
    sed -i "s/^expose_php.*/expose_php = $EXPOSE_PHP/" "$INI"
    sed -i "s|^[;[:space:]]date.timezone.*|date.timezone = $DATE_TIMEZONE|" "$INI"
    sed -i "s/^session.name.*/session.name = $SESSION_NAME/" "$INI"
    sed -i "s|^[;[:space:]]*max_input_vars.*|max_input_vars = $MAX_INPUT_VARS|" "$INI"
    sed -i "s|^[;[:space:]]*error_log.*|error_log = $ERROR_LOG|" "$INI"
    sed -i "s/^session.save_handler.*/session.save_handler = $SESSION_SAVE_HANDLER/" "$INI"
    sed -i "s|^[;[:space:]]session.save_path.*|session.save_path = \"$SESSION_SAVE_PATH\"|" "$INI"
    if ! grep -q "^\[bsedt\]" "$INI"; then
      echo -e "\n[bsedt]\nbsedt.lang_path=\"/home/edokumenty/public_html/apps/edokumenty/share/lang\"\nbsedt.lang=en_UK" >> "$INI"
    else
      echo -e "\033[01;33mSekcja [bsedt] już istnieje w $INI\033[00m"
    fi
done

# Instalacja IONCuber Loader
echo -e "\033[01;34m Instalacja IONCube Loader dla PHP $PHP_VERSION \033[00m"
  cp -p $INSTALL_DIR'/conf/usr/lib/php/ioncube_loader_lin_'$PHP_VERSION'.so' /usr/lib/php/

# Instalacja modulu bsedt - tłumaczenia
echo -e "\033[01;34m Instalacja modulu bsedt - tłumaczenia \033[00m"
PHP_EXT_DIR=$(php -i | grep '^extension_dir' | awk '{print $3}')
	cp -p $INSTALL_DIR'/conf/usr/lib/php/bsedt.so' $PHP_EXT_DIR

# Utworzenie extension dla PHP bsedt
echo "extension=bsedt.so" > /etc/php/$PHP_VERSION/mods-available/bsedt.ini

# Tworzenie linku symbolicznego do modulu bsedt
echo -e "\033[01;34m Tworzenie symlinkow dla pakietu bsedt \033[00m"	
	ln -s /etc/php/$PHP_VERSION/mods-available/bsedt.ini /etc/php/$PHP_VERSION/cli/conf.d/bsedt.ini
	ln -s /etc/php/$PHP_VERSION/mods-available/bsedt.ini /etc/php/$PHP_VERSION/fpm/conf.d/bsedt.ini

# Modyfikacja OPCACHE wyłączenie
echo -e "\033[01;34m Wyłączenie opcache w PHP mods \033[00m" 
    sed -i -e "s/zend_extension=opcache.so/;zend_extension=opcache.so/g" /etc/php/$PHP_VERSION/mods-available/opcache.ini
 
# Utworzene oraz nadanie uprawnień dla pliku php_error.log
  touch /var/log/php_error.log
  chown www-data:www-data /var/log/php_error.log


# Modyfikacja /etc/php/$PHP_VERSION/fpm/pool.d/www.conf
sed -i "s/^;\?security\.limit_extensions.*/security.limit_extensions = .php engine/" /etc/php/$PHP_VERSION/fpm/pool.d/www.conf
sed -i "s/^pm\.max_children.*/pm.max_children = 8/" /etc/php/$PHP_VERSION/fpm/pool.d/www.conf


sleep 2

