<?php

/**
 * FileIndexLog
 *
 * @author Tomasz Świenty
 * @version 0.1
 * @copyright Copyright (c) eDokumenty
 */
final class FileIndexLog {


    private $log = FALSE;


    /**
     * FileIndexLog constructor.
     */
    public function __construct() {

        $this->log = new FileLog(Log::FILE_LOG_WRITER);

    }


    /**
     * @param $message
     * @param int $priority
     */
    public function write($message, $priority = Log::EVENT_INFO) {

        $this->log->setWriterConfig(Log::FILE_LOG_WRITER, array('clsnam' => 'FILE_INDEX'));
        $this->log->write($message, Log::getDayKey(), FALSE, FALSE, $priority);

    }


    /**
     * @param $message
     */
    public function error($message) {

        $this->write($message, Log::EVENT_ERR);

    }

}