#!/bin/bash

INSTALL_DIR=$(pwd)

echo "Instalacja pakietów"
   
apt -y install autoconf-archive automake g++ libtool libleptonica-dev pkg-config
apt -y install git
apt -y install poppler-utils
apt -y install libjpeg-dev libtiff-dev libpng-dev
apt -y install zbar-tools

echo "Instalacja pakietów LEPTONICA"

mkdir /usr/lib/leptonica
cd /usr/lib/leptonica
wget https://github.com/DanBloomberg/leptonica/releases/download/1.86.0/leptonica-1.86.0.tar.gz
gunzip leptonica-1.86.0.tar.gz
tar -xf leptonica-1.86.0.tar
cd leptonica-1.86.0
./configure
make
make install

echo "Instalacja pakietów TESSERACT"

mkdir /usr/lib/tesseract
cd /usr/lib/tesseract
git clone https://github.com/tesseract-ocr/tesseract.git tesseract-ocr
cd tesseract-ocr/
./autogen.sh
./configure --disable-openmp
make
make install
ldconfig

echo "Pobieranie pakietów tessdata"

cd /usr/local/share/tessdata/
wget https://raw.githubusercontent.com/tesseract-ocr/tessdata/main/script/Latin.traineddata
wget https://raw.githubusercontent.com/tesseract-ocr/tessdata/main/pol.traineddata
wget https://raw.githubusercontent.com/tesseract-ocr/tessdata/main/eng.traineddata
wget https://raw.githubusercontent.com/tesseract-ocr/tessdata/main/osd.traineddata


echo "Instalacja pakietów dla BUFFOR OCR"

apt -y install rabbitmq-server
apt -y install python3-pip
apt -y install python3-pika
apt -y install python3-toml
apt -y install python3-pil
apt -y install python3-packaging
pip3 install pdfplumber --break-system-packages
pip3 install opencv-python-headless --break-system-packages
pip3 install pandas --break-system-packages
apt -y install supervisor

apt -y install pdftk

echo "Kopiowanie plików konfiguracyjnych supervisor"

cp -p $INSTALL_DIR'/conf/etc/supervisor/conf.d/ready-worker-bg-task.conf' /etc/supervisor/conf.d/
cp -p $INSTALL_DIR'/conf/etc/supervisor/conf.d/ready-worker-ocr.conf' /etc/supervisor/conf.d/
cp -p $INSTALL_DIR'/conf/etc/supervisor/conf.d/ready-worker-ocr-result.conf' /etc/supervisor/conf.d/
cp -p $INSTALL_DIR'/conf/etc/supervisor/conf.d/ready-worker-sendmail.conf' /etc/supervisor/conf.d/

cd /home/edokumenty/
mkdir -p var
mkdir -p var/tmp
mkdir -p var/log
mkdir -p var/log/cron_runner
mkdir -p var/log/ocr
mkdir -p var/log/ocr_result
mkdir -p var/log/sendmail

chown edokumenty:edokumenty -R /home/edokumenty/var

echo "Restart workerów"
sleep 2
supervisorctl restart all
