#!/bin/bash


# Pobranie najnowszej wersji Symfonia eDokumenty
echo -e "\033[01;31m Pobranie najnowszej wersji Symfonia eDokumenty - podaj login oraz hasło \033[00m"
read -p "Wprowadź login do support.edokumenty.eu: " user
read -p "Wprowadź hasło do support.edokumenty.eu: " pass


if ! wget -qO- --http-user="$user" --http-password="$pass" http://support.edokumenty.eu/download/application/ready/stable/ | sed -e 's/<[^>]*>//g' > downloaded_file.txt; then
	echo -e "\033[01;31m Błąd pobierania listy paczek. Sprawdź login i hasło. \033[00m"
	exit 1
fi
if ! grep -q "Ready_v" downloaded_file.txt; then
	echo -e "\033[01;31m Brak dostępnych paczek lub nieprawidłowe dane logowania. \033[00m"
	exit 1
fi
echo -e "\033[01;31m Lista dostępnych paczek:\033[00m"
grep "Ready_v" downloaded_file.txt | awk '{print NR ". " $1}'
read -p "Podaj numer pliku do pobrania: " file_num
selected_file=$(grep "Ready_v" downloaded_file.txt | awk "NR==$file_num {print \$1}")

while [ -z "$selected_file" ]; do
	echo "Nieprawidłowy wybór. Spróbuj ponownie."
	read -p "Podaj numer pliku do pobrania: " file_num
	selected_file=$(grep "Ready_v" downloaded_file.txt | awk "NR==$file_num {print \$1}")
done

wget --http-user="$user" --http-password="$pass" -P /home/edokumenty https://support.edokumenty.eu/download/application/ready/stable/$selected_file
chown -R edokumenty:www-data /home/edokumenty/$selected_file
chmod 775 /home/edokumenty/$selected_file
su -c "unzip /home/edokumenty/$selected_file" - edokumenty


echo -e "\033[01;31m Pobieranie paczki zakończone. Dalsze kroki wykonaj przez przeglądarkę wpisując adres serwera, na którym zainstalowano Symfonia eDokumenty \033[00m"