#!/bin/bash

#Tworzenie katalogow
echo -e "\033[01;34m Utworzenie folderow w /home/edokumenty/ \033[00m"
if [ ! -d /home/edokumenty ]; then
	mkdir -p /home/edokumenty
fi
cd /home/edokumenty
mkdir -p public_html
mkdir -p repos
mkdir -p repository
mkdir -p maildir
mkdir -p files
mkdir -p public_ftp
mkdir -p users
mkdir -p vendor
mkdir -p public_html/apps
mkdir -p public_html/apps/backproc
mkdir -p public_html/apps/backproc/data
mkdir -p public_html/apps/backproc/logs
mkdir -p public_html/apps/backproc/pid
mkdir -p public_html/apps/edokumenty
mkdir -p public_html/apps/edokumenty/scripts
mkdir -p public_html/apps/edokumenty/scripts/FileIndexingTool
mkdir -p public_html/apps/edokumenty/scripts/FileIndexingTool/conf
mkdir -p public_html/apps/edokumenty/var/cache/tmpl

echo -e "\033[01;34m Nadanie uprawenień do utworzonych folderow \033[00m"
#Uprawnienia do katalogow systemu
chown -R edokumenty:users public_html
chown -R edokumenty:users vendor

# Jeśli dodatkowo nieprawidłowo ustawione są uprawnienia do plików w repozytorium
chown -R www-data:edokumenty files maildir repository repos public_ftp users
# Grant read/write/execute to owner and group, remove all permissions for others for security
chmod -R u+rwX,g+rwX,o-rwx files maildir repository repos public_ftp users

# Ustaw uprawnienia dla podkatalogów katalogu backproc
cd /home/edokumenty/public_html/apps/backproc
chown -R www-data:edokumenty data logs pid
chmod -R u+rwX,g+rwXs,o-rwx data logs pid