#!/bin/bash

INSTALL_DIR="${1:-$(pwd)}"

# Ustawienie wersji aplikacji
source "$(dirname "$0")/config.env"
PHP_VERSION=$(echo "$PHP_VERSION" | tr -d '\n' | tr -d '\r')
POSTGRESQL_VERSION=$(echo "$POSTGRESQL_VERSION" | tr -d '\n' | tr -d '\r')


echo -e "\033[01;34m Kopia została utworzona w lokalizacji '$INSTALL_DIR/backup_conf' \033[00m"

mkdir -p backup_conf
mkdir -p backup_conf/apache2
mkdir -p backup_conf/apache2/conf-available
mkdir -p backup_conf/apache2/mods-available
mkdir -p backup_conf/cli
mkdir -p backup_conf/fpm
mkdir -p backup_conf/fpm/pool.d
mkdir -p backup_conf/redis
mkdir -p backup_conf/pgbouncer
mkdir -p backup_conf/postgresql


echo -e "\033[01;34m Kopia plików konfiguracyjnych Apache \033[00m"
  
  #Konfiguracja Apache2
  cp -r /etc/apache2/sites-available/ $INSTALL_DIR'/backup_conf/apache2/sites-available/'
  cp -p /etc/apache2/apache2.conf $INSTALL_DIR'/backup_conf/apache2/'
  cp -p /etc/apache2/conf-available/security.conf $INSTALL_DIR'/backup_conf/apache2/conf-available/' 
  cp -p /etc/apache2/mods-available/ssl.conf $INSTALL_DIR'/backup_conf/apache2/mods-available/' 
	

echo -e "\033[01;34m Kopia plików konfiguracyjnych PHP \033[00m"	
    # Konfiguracja PHP/FPM


if [ -f "/etc/php/$PHP_VERSION/cli/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/cli/php.ini" "$INSTALL_DIR/backup_conf/cli/"
fi
if [ -f "/etc/php/$PHP_VERSION/fpm/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/php.ini" "$INSTALL_DIR/backup_conf/fpm/"
fi
if [ -f "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" "$INSTALL_DIR/backup_conf/fpm/pool.d/"
fi
# Konfiguracja PHP/FPM
if [ -f "/etc/php/$PHP_VERSION/cli/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/cli/php.ini" "$INSTALL_DIR/backup_conf/cli/"
else
  echo "Plik /etc/php/$PHP_VERSION/cli/php.ini nie istnieje!"
fi

if [ -f "/etc/php/$PHP_VERSION/fpm/php.ini" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/php.ini" "$INSTALL_DIR/backup_conf/fpm/"
else
  echo "Plik /etc/php/$PHP_VERSION/fpm/php.ini nie istnieje!"
fi

if [ -f "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" ]; then
  cp -p "/etc/php/$PHP_VERSION/fpm/pool.d/www.conf" "$INSTALL_DIR/backup_conf/fpm/pool.d/"
else
  echo "Plik /etc/php/$PHP_VERSION/fpm/pool.d/www.conf nie istnieje!"
fi

echo -e "\033[01;34m Kopia plików konfiguracyjnych Redis \033[00m"	
  #Konfiguracja php-redis
if [ -f /etc/redis/redis.conf ]; then
  cp -p /etc/redis/redis.conf $INSTALL_DIR'/backup_conf/redis/'
else
  echo "Plik /etc/redis/redis.conf nie istnieje!"
fi

echo -e "\033[01;34m Kopia plików konfiguracyjnych pgbouncer \033[00m"
	#Konfiguracja pgbouncer
  cp -p /etc/pgbouncer/pgbouncer.ini $INSTALL_DIR'/backup_conf/pgbouncer/'
  if [ -f /etc/pgbouncer/userlist.txt ]; then
    cp -p /etc/pgbouncer/userlist.txt $INSTALL_DIR'/backup_conf/pgbouncer/'


echo -e "\033[01;34m Kopia plików PostgreSQL $POSTGRESQL_VERSION - pg_hba.conf \033[00m"
PG_HBA_CONF="/etc/postgresql/$POSTGRESQL_VERSION/main/pg_hba.conf"
POSTGRESQL_CONF="/etc/postgresql/$POSTGRESQL_VERSION/main/postgresql.conf"

if [ -f "$PG_HBA_CONF" ]; then
  cp -p "$PG_HBA_CONF" "$INSTALL_DIR/backup_conf/postgresql/"
else
  echo "Plik $PG_HBA_CONF nie istnieje!"
fi

if [ -f "$POSTGRESQL_CONF" ]; then
  cp -p "$POSTGRESQL_CONF" "$INSTALL_DIR/backup_conf/postgresql/"
else
  echo "Plik $POSTGRESQL_CONF nie istnieje!"
fi
  cp -p "$PG_HBA_CONF" "$INSTALL_DIR/backup_conf/postgresql/"
else
  echo "Plik $PG_HBA_CONF nie istnieje!"
fi

if [ -f "$POSTGRESQL_CONF" ]; then
  cp -p "$POSTGRESQL_CONF" "$INSTALL_DIR/backup_conf/postgresql/"
else
  echo "Plik $POSTGRESQL_CONF nie istnieje!"
fi
