#!/bin/bash
# Server installation script for 
# Symfonia eDokumenty on Debian Bookworm 12
#
# @version 12.2.4 (20251007) for Debian Bookworm 12 Version PHP 8.2, PostgreSQL 17
# @author: eDokumenty sp z o.o.
# @modified: Symfonia sp z o.o.
# @modified Jarosław Połczyński, jaroslaw.polczynski@symfonia.pl
#
# Instrukacja instalcji znajduje w pliku README.md

INSTALL_DIR=$(pwd)

echo -ne "\033[01;32mCzy chcesz instalowac pakiety managerem apt-get? Zalecane y (y/n) \033[00m \n"
read APTYESNO
if [ "$APTYESNO" = "y" ]; then

#gnupg, wget, sudo
apt-get -y install gnupg
apt-get -y install wget
apt-get -y install sudo
apt-get -y install lsb-release

#Dodane na potrzeby wersji PostgreSQL 17 - nie ma w dystrybucji
echo -e "\033[01;34mDodanie repozytorium dla PostgreSQL 17 \033[00m"
wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | apt-key add -
apt-key export ACCC4CF8 | sudo gpg --dearmour -o /usr/share/keyrings/pgdg.gpg
sudo apt-key del ACCC4CF8
#echo "deb [arch=amd64 signed-by=/usr/share/keyrings/pgdg.gpg] http://apt.postgresql.org/pub/repos/apt/ bookworm"-pgdg main | tee  /etc/apt/sources.list.d/pgdg.list
echo "deb [arch=amd64 signed-by=/usr/share/keyrings/pgdg.gpg] http://apt.postgresql.org/pub/repos/apt/ $(lsb_release -sc)"-pgdg main | tee  /etc/apt/sources.list.d/pgdg.list
sleep 2

#Dodane na potrzeby wersji php8.2 - nie ma w dystrybucji
echo -e "\033[01;34mDodanie repozytorium dla PHP 8.2 \033[00m"
apt -y install ca-certificates apt-transport-https 
wget -q https://packages.sury.org/php/apt.gpg -O- | apt-key add -
apt-key export 95BD4743 | sudo gpg --dearmour -o /usr/share/keyrings/php.gpg
sudo apt-key del 95BD4743
#echo "deb [arch=amd64 signed-by=/usr/share/keyrings/php.gpg] https://packages.sury.org/php/ bookworm main" |  tee /etc/apt/sources.list.d/php.list
echo "deb [arch=amd64 signed-by=/usr/share/keyrings/php.gpg] https://packages.sury.org/php/ $(lsb_release -sc) main" |  tee /etc/apt/sources.list.d/php.list
sleep 1

echo -e "\033[01;34mOdświeżenie repozytoriów \033[00m"
apt-get update

echo -e "\033[01;34mInstalowanie pakietów podstawowych \033[00m"
# Base tools
apt-get -y install ssh
apt-get -y install mc
apt-get -y install nmap
apt-get -y install ngrep
apt-get -y install sed
apt-get -y install gzip
apt-get -y install adduser
apt-get -y install bzip2
apt-get -y install unzip
apt-get -y install rsync
apt-get -y install less
apt-get -y install rdate
apt-get -y install vim
apt-get -y install zip

echo -e "\033[01;34mInstalowanie pakietów systemowych \033[00m"
# System tools
apt-get -y install cron
apt-get -y install iproute2
apt-get -y install tcpdump
apt-get -y install ntp 
apt-get -y install htop
apt-get -y install iotop
apt-get -y install sysstat

echo -e "\033[01;34mInstalowanie dodatkowych pakietów \033[00m"
# Additional tools
apt-get -y install apt-show-versions
apt-get -y install gcc
apt-get -y install g++
apt-get -y install cpp
apt-get -y install make
apt-get -y install curl
apt-get -y install unattended-upgrades

# Processing tools
apt-get -y install imagemagick
apt-get -y install html2ps
apt-get -y install latex2rtf
apt-get -y install antiword
apt-get -y install gnuhtml2latex
#Tesseract kompilujemy ze źródeł. Skrypt ocr_packet.sh
#apt-get -y install tesseract-ocr
#apt-get -y install tesseract-ocr-pol

echo -e "\033[01;34mInstalowanie pakietów Apache2, PostgreSQL 17 \033[00m"
# Services Apache, PostgreSQL17
apt-get -y install postgresql-17
apt-get -y install apache2
apt-get -y install libapache2-mod-security2

echo -e "\033[01;34mInstalowanie pakietów PHP 8.2 \033[00m"
# Services PHP 
apt-get -y install php8.2-fpm 
apt-get -y install php8.2-cli 
apt-get -y install php8.2-common 
apt-get -y install php8.2-curl 
apt-get -y install php8.2-mbstring 
apt-get -y install php8.2-mysql 
apt-get -y install php8.2-xml 
apt-get -y install php8.2-gd 
apt-get -y install php8.2-pgsql 
apt-get -y install php8.2-bcmath 
apt-get -y install php8.2-sqlite3 
apt-get -y install php8.2-imap 
apt-get -y install php8.2-xsl 
apt-get -y install php8.2-ldap 
apt-get -y install php8.2-odbc 
apt-get -y install php8.2-sybase 
apt-get -y install php8.2-readline 
apt-get -y install php8.2-soap
apt-get -y install php8.2-zip
apt-get -y install php8.2-redis
apt-get -y install php8.2-zmq

echo -e "\033[01;34mInstalowanie pakietów Redis-Server \033[00m"
apt-get -y install redis-server

apt-get -y install subversion
apt-get -y install openssl
apt-get -y install ssl-cert
apt-get -y install abiword
apt-get -y install hdparm

fi


# Instalacja pgbouncer + config
echo -ne "\033[01;32mCzy zainstalowac Pgbouncer? (y/n) \033[00m \n"
read PGBOUNCER
if [ "$PGBOUNCER" = "y" ]; then
    apt-get -y install pgbouncer
fi

# Instalacja polityka haseł dla usera systemu linux
echo -ne "\033[01;32mCzy wprowadzić nową politykę haseł dla użytkowników systemu? (y/n) \033[00m \n"
read POLICYUSER
if [ "$POLICYUSER" = "y" ]; then
    apt -y install libpam-pwquality
    sed -i -e "s/password        requisite                       pam_pwquality.so retry=3/password    requisite           pam_pwquality.so retry=3 minlen=16 maxrepeat=3 ucredit=-1 lcredit=-1 dcredit=-1 ocredit=-1 difok=3 reject_username enforce_for_root/g" /etc/pam.d/common-password
fi



echo -e "\033[01;34mZakladanie kont i konfiguracja grup dla użytkownika edokumenty \033[00m"
# konta i grupy systemowe dla usera edokumenty
/usr/sbin/adduser --gecos  "" --ingroup users edokumenty
/usr/sbin/groupadd edokumenty
/usr/sbin/adduser edokumenty edokumenty
/usr/sbin/adduser www-data edokumenty

chmod g+rx,o+rx /home/edokumenty


echo -e "\033[01;34mZakladanie kont i konfiguracja grup dla użytkownika test \033[00m"
# konta i grupy systemowe dla usera test
/usr/sbin/adduser --gecos  "" --ingroup users test
/usr/sbin/groupadd test

chmod g+rx,o+rx /home/test

echo -e "\033[01;34mAktywacja modulow Apache2 \033[00m"
for module in ssl rewrite userdir vhost_alias actions alias proxy_fcgi headers security2
do 
   /usr/sbin/a2enmod $module;
done

#enable ssl
/usr/sbin/a2ensite default-ssl


# Kopia plikow konfiguracyjnych
echo -ne "\033[01;32mCzy wykonać kopię plików konfiguracyjnych (y/n) \033[00m \n"
read BACKUPCONF
if [ "$BACKUPCONF" = "y" ]; then
    ./bin/backup_conf_client.sh
fi

# Modyfikacje plików konfiguracyjnych
echo -ne "\033[01;32mCzy modyfikowac pliki konfiguracyjne (zalecane y)? (y/n) \033[00m \n"
read CONFYESNO
if [ "$CONFYESNO" = "y" ]; then
echo -e "\033[01;34mModyfikacja plików konfiguracyjnych Apache2 \033[00m"
	# Zmiana konfiguracji hostow Apache
    rm -f /etc/apache2/sites-available/*
    cp -p $INSTALL_DIR'/conf/etc/apache2/sites-available/000-default.conf' /etc/apache2/sites-available/
    cp -p $INSTALL_DIR'/conf/etc/apache2/sites-available/default-ssl.conf' /etc/apache2/sites-available/
	cp -p $INSTALL_DIR'/conf/etc/apache2/sites-enabled/test.conf' /etc/apache2/sites-enabled/
    cp -p $INSTALL_DIR'/conf/etc/apache2/apache2.conf' /etc/apache2/
	cp -p $INSTALL_DIR'/conf/etc/apache2/conf-available/security.conf' /etc/apache2/conf-available/
	cp -p $INSTALL_DIR'/conf/etc/apache2/mods-available/ssl.conf' /etc/apache2/mods-available/


echo -e "\033[01;34mDostarczenie certyfiaktu dla localhost \033[00m"
   # Kopiowanie testowego certyfiaktu dla SSL
    cp -p $INSTALL_DIR'/conf/etc/ssl/edokumenty.pem' /etc/ssl/private/
    cp -p $INSTALL_DIR'/conf/etc/ssl/edokumenty.key' /etc/ssl/private/

echo -e "\033[01;34mModyfikacja plików konfiguracyjnych PHP-FPM \033[00m"
    # Konfiguracja PHP/FPM
    cp -p $INSTALL_DIR'/conf/etc/php/8.2/cli/php.ini' /etc/php/8.2/cli/
	cp -p $INSTALL_DIR'/conf/etc/php/8.2/fpm/php.ini' /etc/php/8.2/fpm/
	cp -p $INSTALL_DIR'/conf/etc/php/8.2/fpm/pool.d/www.conf' /etc/php/8.2/fpm/pool.d/
	cp -p $INSTALL_DIR'/conf/etc/php/8.2/mods-available/bsedt.ini' /etc/php/8.2/mods-available/

echo -e "\033[01;34mModyfikacja plików konfiguracyjnych Redis \033[00m"	
	  #Konfiguracja php-redis
    cp -p $INSTALL_DIR'/conf/etc/redis/redis.conf' /etc/redis/


echo -e "\033[01;34mModyfikacja plików konfiguracyjnych pgBouncer \033[00m"
	#Konfiguracja pgbouncer
    cp -p $INSTALL_DIR'/conf/etc/pgbouncer/pgbouncer.ini' /etc/pgbouncer
    cp -p $INSTALL_DIR'/conf/etc/pgbouncer/userlist.txt' /etc/pgbouncer


echo -e "\033[01;34mModyfikacja plików konfiguracyjnych PostgreSQL 17 - pg_hba.conf \033[00m"
	cp -p $INSTALL_DIR'/conf/etc/postgresql/17/main/pg_hba.conf' /etc/postgresql/17/main

echo -e "\033[01;34mTworzenie symlinkow dla pakietu bsedt \033[00m"	
	# Tworzenie linku symbolicznego do modulu bsedt
	ln -s /etc/php/8.2/mods-available/bsedt.ini /etc/php/8.2/cli/conf.d/bsedt.ini
	ln -s /etc/php/8.2/mods-available/bsedt.ini /etc/php/8.2/fpm/conf.d/bsedt.ini
 
echo -e "\033[01;34mWyłączenie opcache \033[00m" 
	
    #Modyfikacja OPCACHE wyłączenie
    sed -i -e "s/zend_extension=opcache.so/;zend_extension=opcache.so/g" /etc/php/8.2/mods-available/opcache.ini

  #Utworzene oraz nadanie uprawnień dla pliku php_error.log
  touch /var/log/php_error.log
  chown www-data:www-data /var/log/php_error.log

fi

echo -e "\033[01;34mPoprawa uprawnień do plików konfiguracyjnych \033[00m"
./bin/sys_perms.sh

echo -e "\033[01;34mZmiana konfiguracji dla PostgreSQL 17 \033[00m"
./bin/postgresql.sh

echo -e "\033[01;34mUtworzenie public_html i pozostałych podkatalogów. Nadanie uprawenień do odczytu i zapisu \033[00m"
./bin/create_edok_dirs.sh

echo -e "\033[01;34mDodanie ramdisk w fstab dla usługi backproc \033[00m"
./bin/fstab.sh

echo -e "\033[01;34mWyłączenie PolicyMap dla PDF \033[00m"
./bin/imagemagick.sh

# Instalacja IONCuber Loader
echo -ne "\033[01;32mCzy chcesz instalowac modul IONCube Loader dla PHP 8.2? (y/n) \033[00m \n"
read CONFYESNO
if [ "$CONFYESNO" = "y" ]; then
    echo -e "\033[01;34mInstalacja IONCube Loader dla PHP 8.2 \033[00m"
    cp   $INSTALL_DIR'/conf/usr/lib/php/ioncube_loader_lin_8.2.so' /usr/lib/php/
fi


echo -e "\033[01;34mInstalacja modulu bsedt - tłumaczenia \033[00m"
	cp   $INSTALL_DIR'/conf/usr/lib/php/20220829/bsedt.so' /usr/lib/php/20220829/


# Tworzenie użytkowników bazy danych (wszyscy z opcjami N)
echo -e "\033[01;34mTworzenie uzytkownika bazy danych - http (wszystkie opcje N) \033[00m"
sudo -u postgres createuser --no-superuser --no-createdb --no-createrole http
echo -e "\033[01;34mTworzenie uzytkownika bazy danych - edokumenty (wszystkie opcje N) \033[00m"
sudo -u postgres createuser --no-superuser --no-createdb --no-createrole edokumenty


# Tworzenie baz danych
echo -e "\033[01;34mTworzenie pustej bazy edokumenty \033[00m"
sudo -u postgres createdb -E UTF8 edokumenty -O edokumenty



echo -e "\033[01;34mKonfiguracja domyslnego backupu - domyslne skrypty, ustawienia backapu i skrypty crona \033[00m"
./bin/backup_dirs.sh

cd $INSTALL_DIR
  cp -p $INSTALL_DIR'/lib/backup/backup_db.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_repos.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_files.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_publichtml.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/backup_repository.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/clear_edok_var.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/maildrop_clear.sh' /etc/backup/
  cp -p $INSTALL_DIR'/lib/backup/update_test.sh' /etc/backup/

  chmod 755 /etc/backup/*

  cp -p $INSTALL_DIR'/lib/backup/exclude_test.conf' /etc/backup

  cp -p $INSTALL_DIR'/lib/backup/edokumenty' /etc/cron.d/

# Restart Apache i Postgres
echo -e "\033[01;34mRestart Apache \033[00m"
sleep 2
/etc/init.d/apache2 restart

echo -e "\033[01;34mRestart PHP 8.2 FMP \033[00m"
sleep 2
/etc/init.d/php8.2-fpm restart

echo -e "\033[01;34mRestart PostgreSQL \033[00m"
sleep 2
/etc/init.d/postgresql restart


echo -e "\033[01;34mFileIndexingTool - tworzenie katalogow oraz przenoszenie skryptow \033[00m"

  cp $INSTALL_DIR'/lib/FileIndexingTool/Run.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndex.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndexLog.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/FileIndexStatus.inc'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/
  cp $INSTALL_DIR'/lib/FileIndexingTool/conf/config.json'  /home/edokumenty/public_html/apps/edokumenty/scripts/FileIndexingTool/conf/

echo -e "\033[01;34mDodanie wpisow do systemowego crona \033[00m"
./bin/cron.sh

echo -ne "\033[01;32mInstalacja pakietów dodatkowych OCR? (y/n) \033[00m \n"
read CONFYESNO
if [ "$CONFYESNO" = "y" ]; then
    echo -e "\033[01;34mInstalacja pakietów Tesseract \033[00m"
    ./bin/ocr_packet.sh
fi

echo -ne "\033[01;32mInstalacja dla Generowanie podglądu plików do PDF? (y/n) \033[00m \n"
read CONFYESNO
if [ "$CONFYESNO" = "y" ]; then
    echo -e "\033[01;34mInstalacja dla Generowanie podglądu plików do PDF \033[00m"
    ./bin/libreoffice.sh
fi

echo -e "\033[01;32mKoniec pracy instalatora \033[00m"