#!/bin/bash

INSTALL_DIR=$(pwd)

echo -e "\033[01;34mKopia została utworzona w lokalizacji '$INSTALL_DIR/backup_conf' \033[00m"

mkdir -p backup_conf
mkdir -p backup_conf/apache2
mkdir -p backup_conf/apache2/conf-available
mkdir -p backup_conf/apache2/mods-available
mkdir -p backup_conf/cli
mkdir -p backup_conf/fpm
mkdir -p backup_conf/fpm/pool.d
mkdir -p backup_conf/redis
mkdir -p backup_conf/pgbouncer
mkdir -p backup_conf/postgresql


echo -e "\033[01;34mKopia plików konfiguracyjnych Apache \033[00m"
   
  cp -r /etc/apache2/sites-available/ $INSTALL_DIR'/backup_conf/apache2/sites-available/'
  cp -p /etc/apache2/apache2.conf $INSTALL_DIR'/backup_conf/apache2/'
	cp -p /etc/apache2/conf-available/security.conf $INSTALL_DIR'/backup_conf/apache2/conf-available/' 
	cp -p /etc/apache2/mods-available/ssl.conf $INSTALL_DIR'/backup_conf/apache2/mods-available/' 
	

echo -e "\033[01;34mKopia plików konfiguracyjnych PHP \033[00m"	
    # Konfiguracja PHP/FPM
  cp -p /etc/php/8.1/cli/php.ini $INSTALL_DIR'/backup_conf/cli/'
	cp -p /etc/php/8.1/fpm/php.ini $INSTALL_DIR'/backup_conf/fpm/' 
	cp -p /etc/php/8.1/fpm/pool.d/www.conf $INSTALL_DIR'/backup_conf/fpm/pool.d/' 

echo -e "\033[01;34mKopia plików konfiguracyjnych Redis \033[00m"	
	#Konfiguracja php-redis
  cp -p /etc/redis/redis.conf $INSTALL_DIR'/backup_conf/redis/'

echo -e "\033[01;34mKopia plików konfiguracyjnych pgbouncer \033[00m"
	#Konfiguracja pgbouncer
  cp -p /etc/pgbouncer/pgbouncer.ini $INSTALL_DIR'/backup_conf/pgbouncer/'
  cp -p /etc/pgbouncer/userlist.txt $INSTALL_DIR'/backup_conf/pgbouncer/'
	
echo -e "\033[01;34mKopia plików PostgreSQL - pg_hba.conf \033[00m"
	cp -p /etc/postgresql/17/main/pg_hba.conf $INSTALL_DIR'/backup_conf/postgresql/'
  cp -p /etc/postgresql/17/main/postgresql.conf $INSTALL_DIR'/backup_conf/postgresql/'